<?php  
require_once '../includes/db.php';  
require_once '../includes/functions.php';  
if (!isLoggedIn()) redirect('login.php');  
  
$stmt = $pdo->query("SELECT * FROM app_settings WHERE id = 1");  
$settings = $stmt->fetch(PDO::FETCH_ASSOC);  
  
if ($_SERVER['REQUEST_METHOD'] === 'POST') {  
  $app_name = $_POST['app_name'];  
  $video_id = $_POST['video_id'];  
  $telegram_id = $_POST['telegram_id'];  
  $email = $_POST['email'];  
  
  $logo = $settings['logo'];  
  if (!empty($_FILES['logo']['name'])) {  
    $logo = 'logo_' . time() . '.' . pathinfo($_FILES['logo']['name'], PATHINFO_EXTENSION);  
    move_uploaded_file($_FILES['logo']['tmp_name'], 'uploads/' . $logo);  
  }  
  
$apk_file = $settings['apk_file'];  
if (!empty($_FILES['apk_file']['name'])) {  
    $apk_file = basename($_FILES['apk_file']['name']); // use the same file name as uploaded
    $targetApk = 'uploads/' . $apk_file;

    if (file_exists($targetApk)) {
        unlink($targetApk);
    }

    move_uploaded_file($_FILES['apk_file']['tmp_name'], $targetApk);  
}
 
  
  $update = $pdo->prepare("UPDATE app_settings SET app_name=?, logo=?, apk_file=?, video_id=?, telegram_id=?, email=? WHERE id=1");  
  $update->execute([$app_name, $logo, $apk_file, $video_id, $telegram_id, $email]);  
  $msg = " Settings updated successfully!";  
}  
?>  <!DOCTYPE html>  <html lang="en">  
<head>  
  <meta charset="UTF-8">  
  <title>App Settings</title>  
  <meta name="viewport" content="width=device-width, initial-scale=1">  
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">  
</head>  
<body class="bg-light">  <?php include 'nav.php'; ?>  <div class="container py-3">  
  <div class="col-lg-7 col-md-9 col-sm-12 mx-auto">  
    <div class="card shadow border-0">  
      <div class="card-header bg-primary text-white text-center py-3 d-flex align-items-center justify-content-center">  
        <svg xmlns="http://www.w3.org/2000/svg" width="22" height="22" fill="white" class="me-2" viewBox="0 0 24 24"><path d="M4 4h16v2H4zM4 11h16v2H4zM4 18h16v2H4z"/></svg>  
        <h4 class="mb-0">App Settings</h4>  
      </div>  <div class="card-body p-4">  
    <?php if (!empty($msg)): ?>  
      <div class="alert alert-success text-center fw-semibold"><?= $msg ?></div>  
    <?php endif; ?>  

    <form method="POST" enctype="multipart/form-data">  

      <div class="mb-3">  
        <label class="form-label fw-semibold">App Name</label>  
        <input type="text" name="app_name" value="<?= htmlspecialchars($settings['app_name']); ?>" class="form-control" required>  
      </div>  

      <div class="mb-3">  
        <label class="form-label fw-semibold">Logo</label>  
        <input type="file" name="logo" class="form-control mb-2">  
        <?php if ($settings['logo']): ?>  
          <div class="text-center">  
            <img src="uploads/<?= htmlspecialchars($settings['logo']); ?>" alt="Logo" class="img-fluid rounded shadow-sm" style="max-height:80px;">  
          </div>  
        <?php endif; ?>  
      </div>  

      <div class="mb-3">  
        <label class="form-label fw-semibold">APK File</label>  
        <input type="file" name="apk_file" class="form-control mb-2">  
        <?php if ($settings['apk_file']): ?>  
          <a href="uploads/<?= htmlspecialchars($settings['apk_file']); ?>" target="_blank" class="btn btn-sm btn-outline-success w-100">Download Current APK</a>  
        <?php endif; ?>  
      </div>  

      <div class="mb-3">  
        <label class="form-label fw-semibold">YouTube Video ID</label>  
        <input type="text" name="video_id" value="<?= htmlspecialchars($settings['video_id']); ?>" class="form-control">  
      </div>  

      <div class="mb-3">  
        <label class="form-label fw-semibold">Telegram ID</label>  
        <input type="text" name="telegram_id" value="<?= htmlspecialchars($settings['telegram_id']); ?>" class="form-control">  
      </div>  

      <div class="mb-3">  
        <label class="form-label fw-semibold">Support Email</label>  
        <input type="email" name="email" value="<?= htmlspecialchars($settings['email']); ?>" class="form-control">  
      </div>  

      <button class="btn btn-primary w-100 py-2 fw-semibold"> Save Changes</button>  
    </form>  
  </div>  

  </div>  
</div>

  </div>  
</div>  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>  </body>  
</html> 