<?php
require_once '../includes/db.php';
require_once '../includes/functions.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $username = $_POST['username'];
  $password = $_POST['password'];

  $stmt = $pdo->prepare("SELECT * FROM admin WHERE username = ?");
  $stmt->execute([$username]);
  $admin = $stmt->fetch(PDO::FETCH_ASSOC);

  if ($admin && password_verify($password, $admin['password'])) {
    $_SESSION['admin_logged_in'] = true;
    redirect('dashboard.php');
  } else {
    $error = "Invalid credentials!";
  }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Admin Login</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

  <style>
    body {
      background: linear-gradient(135deg, #007bff, #6610f2);
      min-height: 100vh;
      display: flex;
      align-items: center;
      justify-content: center;
      font-family: 'Poppins', sans-serif;
    }
    .login-card {
      background: #fff;
      border-radius: 16px;
      box-shadow: 0 10px 30px rgba(0,0,0,0.1);
      padding: 2rem;
      width: 100%;
      max-width: 380px;
      animation: fadeIn 0.6s ease-in-out;
    }
    .login-card h4 {
      font-weight: 600;
      color: #333;
    }
    .login-card .form-control {
      border-radius: 10px;
      padding: 10px 14px;
    }
    .login-card button {
      border-radius: 10px;
      font-weight: 500;
      background: linear-gradient(90deg, #007bff, #6610f2);
      border: none;
    }
    .login-card button:hover {
      opacity: 0.9;
    }
    .icon {
      width: 50px;
      height: 50px;
      background: linear-gradient(135deg, #007bff, #6610f2);
      border-radius: 50%;
      display: flex;
      align-items: center;
      justify-content: center;
      margin: 0 auto 15px;
      color: #fff;
    }
    .footer-text {
      font-size: 0.85rem;
      text-align: center;
      color: #777;
      margin-top: 15px;
    }
    @keyframes fadeIn {
      from {opacity: 0; transform: translateY(20px);}
      to {opacity: 1; transform: translateY(0);}
    }
  </style>
</head>

<body>
  <div class="login-card">
    <div class="icon">
      <svg xmlns="http://www.w3.org/2000/svg" width="28" height="28" fill="none" viewBox="0 0 24 24" stroke="currentColor">
        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" 
              d="M12 11c.828 0 1.5-.672 1.5-1.5S12.828 8 12 8s-1.5.672-1.5 1.5S11.172 11 12 11z" />
        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" 
              d="M12 14v.01M7.05 7.05A7 7 0 0112 5c3.866 0 7 3.134 7 7 0 3.866-3.134 7-7 7a7 7 0 01-4.95-1.95M4 4l16 16" />
      </svg>
    </div>
    <h4 class="text-center mb-3">Admin Login</h4>

    <?php if (!empty($error)): ?>
      <div class="alert alert-danger py-2 text-center"><?= $error ?></div>
    <?php endif; ?>

    <form method="POST">
      <div class="mb-3">
        <input type="text" name="username" placeholder="Username" class="form-control" required>
      </div>
      <div class="mb-3">
        <input type="password" name="password" placeholder="Password" class="form-control" required>
      </div>
      <button type="submit" class="btn btn-primary w-100 py-2">Login</button>
    </form>

    <p class="footer-text mt-3">&copy; <?= date('Y') ?> Admin Panel</p>
  </div>

  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
